/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.recipe.flask.RecipePotionTransform;

public class PotionTransformRecipeSerializer<RECIPE extends RecipePotionTransform>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public PotionTransformRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        if (json.has("input") && GsonHelper.m_13885_((JsonObject)json, (String)"input")) {
            JsonArray mainArray = GsonHelper.m_13933_((JsonObject)json, (String)"input");
            for (Object element : mainArray) {
                if (inputList.size() >= 5) break;
                if (element.isJsonArray()) {
                    element = element.getAsJsonArray();
                } else {
                    element.getAsJsonObject();
                }
                inputList.add(Ingredient.m_43917_((JsonElement)element));
            }
        }
        ArrayList<Pair<MobEffect, Integer>> outputEffectList = new ArrayList<Pair<MobEffect, Integer>>();
        if (json.has("outputEffect") && GsonHelper.m_13885_((JsonObject)json, (String)"outputEffect")) {
            JsonArray mainArray = GsonHelper.m_13933_((JsonObject)json, (String)"outputEffect");
            for (Object element : mainArray) {
                JsonObject obj = element.getAsJsonObject();
                MobEffect outputEffect = BloodMagicPotions.getEffect(new ResourceLocation(GsonHelper.m_13906_((JsonObject)obj, (String)"effect")));
                int baseDuration = GsonHelper.m_13927_((JsonObject)obj, (String)"baseDuration");
                outputEffectList.add((Pair<MobEffect, Integer>)Pair.of((Object)outputEffect, (Object)baseDuration));
            }
        }
        ArrayList<MobEffect> inputEffectList = new ArrayList<MobEffect>();
        if (json.has("inputEffect") && GsonHelper.m_13885_((JsonObject)json, (String)"inputEffect")) {
            JsonArray mainArray = GsonHelper.m_13933_((JsonObject)json, (String)"inputEffect");
            for (JsonElement element : mainArray) {
                MobEffect inputEffect = BloodMagicPotions.getEffect(new ResourceLocation(GsonHelper.m_13805_((JsonElement)element, (String)"effect")));
                inputEffectList.add(inputEffect);
            }
        }
        int syphon = GsonHelper.m_13927_((JsonObject)json, (String)"syphon");
        int ticks = GsonHelper.m_13927_((JsonObject)json, (String)"ticks");
        int minimumTier = GsonHelper.m_13927_((JsonObject)json, (String)"upgradeLevel");
        return this.factory.create(recipeId, inputList, outputEffectList, inputEffectList, syphon, ticks, minimumTier);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<Ingredient> input = new ArrayList<Ingredient>(size);
        for (int i = 0; i < size; ++i) {
            input.add(i, Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        int syphon = buffer.readInt();
        int ticks = buffer.readInt();
        int minimumTier = buffer.readInt();
        int outputEffectSize = buffer.readInt();
        ArrayList<Pair<MobEffect, Integer>> outputEffectList = new ArrayList<Pair<MobEffect, Integer>>(outputEffectSize);
        for (int i = 0; i < outputEffectSize; ++i) {
            int effectId = buffer.readInt();
            outputEffectList.add(i, Pair.of((Object)MobEffect.m_19453_((int)effectId), (Object)buffer.readInt()));
        }
        int inputEffectSize = buffer.readInt();
        ArrayList<MobEffect> inputEffectList = new ArrayList<MobEffect>();
        for (int i = 0; i < inputEffectSize; ++i) {
            inputEffectList.add(i, MobEffect.m_19453_((int)buffer.readInt()));
        }
        return this.factory.create(recipeId, input, outputEffectList, inputEffectList, syphon, ticks, minimumTier);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        ((RecipePotionTransform)recipe).write(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipePotionTransform> {
        public RECIPE create(ResourceLocation var1, List<Ingredient> var2, List<Pair<MobEffect, Integer>> var3, List<MobEffect> var4, int var5, int var6, int var7);
    }
}

